#include <bits/stdc++.h>

using namespace std;

const int maxN = 150000;
const int maxK = 300000;
int long long N,K;
pair<int,int> trkaci[maxN];

vector<double> nizPreticanja;
int duzinaNizaPreticanja;

// Racuna vreme nakon kog ce se preteci
void delta(int x1, int v1, int x2, int v2)
{
    double time;
    if (v1 == v2)
    {
        // Trkaci se krecu istom brzinom, nema preticanja
        return;
    }

    if (v1 < v2 and x2 < x1)
    {
        // Trkac 1 je sporiji od trkaca 2
        time = double(x2 - x1) / double(v1 - v2);
        nizPreticanja.push_back(time);
    }
    if(v1 > v2 and x1 < x2)
    {
        // Trkac 2 je sporiji od trkaca 1
        time = double(x1 - x2) / double(v2 - v1);
        nizPreticanja.push_back(time);
    }
    return;
}


// Pomocna funkcija merge sorta
void customMergeSortHelp(int levo, int sredina, int desno)
{
    // Pravimo dva privremena sub niza
    int duzinaLevog = sredina - levo + 1;
    int duzinaDesnog = desno - sredina;

    pair<int,int> leviNiz[duzinaLevog];
    pair<int,int> desniNiz[duzinaDesnog];

    for(int i=0;i<duzinaLevog;i++)
    {
        leviNiz[i].first = trkaci[levo+i].first;
        leviNiz[i].second = trkaci[levo+i].second;
    }
    for(int i=0;i<duzinaDesnog;i++)
    {
        desniNiz[i].first = trkaci[sredina+1+i].first;
        desniNiz[i].second = trkaci[sredina+1+i].second;
    }


    // Spajamo dva privremena sub niza u jedan
    int indexLevog = 0, indexDesnog = 0, indexSpojenog = levo;

     // Prolazimo kroz loop sve dok ne prodjemo sve elemente oba niza
    while (indexLevog < duzinaLevog && indexDesnog < duzinaDesnog)
    {
        // Call delta function to calculate time of overtaking
        //delta(leviNiz[indexLevog].first, leviNiz[indexLevog].second,
        //      desniNiz[indexDesnog].first, desniNiz[indexDesnog].second);

        if (leviNiz[indexLevog].second <= desniNiz[indexDesnog].second)
        {
            trkaci[indexSpojenog].first = leviNiz[indexLevog].first;
            trkaci[indexSpojenog].second = leviNiz[indexLevog].second;

            for(int i=indexDesnog;i<duzinaDesnog;i++)
            {
                // Call delta function to calculate time of overtaking
                delta(leviNiz[indexLevog].first, leviNiz[indexLevog].second,
                     desniNiz[i].first, desniNiz[i].second);
            }

            indexLevog++;
        }
        else
        {
            trkaci[indexSpojenog].first = desniNiz[indexDesnog].first;
            trkaci[indexSpojenog].second = desniNiz[indexDesnog].second;

            for(int i=indexLevog;i<duzinaLevog;i++)
            {
                // Call delta function to calculate time of overtaking
                delta(leviNiz[i].first, leviNiz[i].second,
                     desniNiz[indexDesnog].first, desniNiz[indexDesnog].second);
            }

            indexDesnog++;
        }
        indexSpojenog++;
    }

    // Handle the remaining elements
    while (indexLevog < duzinaLevog)
    {
        trkaci[indexSpojenog].first = leviNiz[indexLevog].first;
        trkaci[indexSpojenog].second = leviNiz[indexLevog].second;
        indexLevog++;
        indexSpojenog++;
    }

    while (indexDesnog < duzinaDesnog)
    {
        trkaci[indexSpojenog].first = desniNiz[indexDesnog].first;
        trkaci[indexSpojenog].second = desniNiz[indexDesnog].second;
        indexDesnog++;
        indexSpojenog++;
    }

    return;
}


// Sortira niz tako da bude sortiran po drugoj vrednosti para
// Istovremeno pravi niz sa vremenima preticanja
void customMergeSort(int pocetak, int kraj)
{
    // Ako je pocetak veci od kraja ne mozemo vise da delimo niz
    if(pocetak < kraj)
    {
     	// Delimo niz na dva dela
    	int sredina = pocetak + (kraj - pocetak) / 2;
    	customMergeSort(pocetak, sredina);
    	customMergeSort(sredina + 1, kraj);


    	// Spajamo dva dela
    	customMergeSortHelp(pocetak, sredina, kraj);
    }
    return;
}


int main()
{
    // Ulaz
    cin>>N>>K;
    for(int i=0;i<N;i++)
    {
        int X,V;
        cin>>X>>V;
        trkaci[i].first = X;
        trkaci[i].second = V;
    }
    cout<<endl;


    // Sortiranje niza po drugoj vrednosti
    // i formiranje niza vremena preticanja
    customMergeSort(0, N-1);


    // Sortiranje niza preticanja
    sort(nizPreticanja.begin(), nizPreticanja.end());


    // Izlaz
    for(int i=0; i<nizPreticanja.size();i++)
    {
        //cout<<nizPreticanja[i]<<endl;
    }

    cout<<nizPreticanja[K-1];
    return 0;
}